
#include <avr/io.h>
#include <i2c.h>

#define	SYSCLK		8000000				// Taktfrequenz des Controllers

#define	UART_UBRR	25

void init(void);
void delay(unsigned int ms);

int main(void)
{
	unsigned char i=0, richtung, k;
	
	//init_uart();
	
	richtung = 0;
	
	i2c_init();

	i2c_start();
	i2c_write_byte(0x7E + I2C_WRITE);
	i2c_write_byte(0xaa);
	i2c_stop();

	while(1)
	{
		for (k=0;k<10;k++)
		{
			/*UDR = '#';
			while ( !( UCSRA & (1<<UDRE)) );				//Warten bis das nchste Byte gesendet werden kann.
			UDR = 'S';
			while ( !( UCSRA & (1<<UDRE)) );
			UDR = k;
			while ( !( UCSRA & (1<<UDRE)) );
			UDR = i;
			while ( !( UCSRA & (1<<UDRE)) );*/
			
			i2c_start();
			i2c_write_byte(0x50 + I2C_WRITE);
			i2c_write_byte(k);
			i2c_write_byte(i);
			i2c_stop();
		}
		
		if (i > 254)
			richtung = 1;
		if (i < 1)
			richtung = 0;
		
		if (richtung == 0)
			i++;
		else
			i--;
		
		delay(10);
	}
	
	return 0;
}


/* Initialisieren des UART */
void init_uart(void)
{
	UCSRB = (1<<TXEN);
	UCSRC = (1<<URSEL) | (1<<UCSZ1) | (1<<UCSZ0);
	UBRRL = (unsigned char) (UART_UBRR & 0x00ff);
	UBRRH = (unsigned char) (UART_UBRR>>8);
}


/* eine kleine Warteschleife */
void delay(unsigned int ms)
{
	unsigned int zaehler;
	
	while (ms) 
	{
		zaehler = SYSCLK / 5000;
		while (zaehler) 
		{
			asm volatile ("nop");
			zaehler--;
		}
		ms--;
	}
}
